import java.math.BigInteger;
public class Collatz {

/**
 * Kalkuliatorius.  Patikrinti, ar duotasis (didelis) skaicius tenkina
 * Collatz'o hipoteze.
 *
*/

    public static void main(String[] args) {

        /* Suzinoti, kiek pateikta argumentu.*/
        if (args.length == 0) {
		System.out.println("Nera pateiktas argumentas (skaicius).");
		System.exit(-1);
	}
	if (args.length > 1) {
		System.out.println("Pateikta per daug argumentu (skaiciu).");
		System.exit(-2);
	}

	/* Priskirti argumenta BigInteger reiksmei n. */
        BigInteger n = new BigInteger(args[0]);
        int count  = 0, negative = 0;
	
	/*Patikrinti, ar tai teigiamas skaicius*/
	negative = n.signum();
	if (negative <= 0) {
		System.out.println(""+n+" nera teigiamas skaicius.");
		System.exit(-3);
	}

        /* Collatzo algoritmas (LOOP), iki kol n=1. */
        while (!n.equals(BigInteger.ONE)) {
		if (n.testBit(0) == true) {
			n = n.multiply(BigInteger.valueOf(3));
			n = n.add(BigInteger.ONE);
		}	
		else {
			n = n.divide(BigInteger.valueOf(2));
		}
		System.out.println(n);
		count++;
        }

        /* Isspausdinti, kiek zingsniu prireike Collatz'o hipotezes algoritmui. */
        System.out.println("Prireike "+count+" zingsniu.");
	System.exit(0);
    }
}